
library(RGoogleDocs)
if(!is.null(getOption("GoogleDocsPassword"))) 
  assign("GoogleDocsPassword", getOption("GoogleDocsPassword"))

# Need the GOOGLE_DOCS_PASSWORD to be set as an environment
# variable or as an option(GoogleDocsPassword = c(login = "password") .
if(exists("GoogleDocsPassword") || Sys.getenv("GOOGLE_DOCS_PASSWORD") != "") {
   auth = getGoogleAuth(service = "wise")
   con  = getGoogleDocsConnection(auth)
   docs = getDocs(con)
   ws = getWorksheets(docs[["StringsAsFactors"]], con)
   tmp = sheetAsMatrix(ws[[1]], con = con, stringsAsFactors = FALSE)
   stopifnot( !( "factor" %in% sapply(tmp, class) ))
   tmp = sheetAsMatrix(ws[[1]], con = con)
   stopifnot("factor" %in% sapply(tmp, class))
}
